<?php
  function NOF_PrepareSQLParameter( $value, $isNumeric ) {
    if (!$isNumeric) {
        global $NOF_DB_CONN;
        return $NOF_DB_CONN->qstr($value, get_magic_quotes_gpc());
    } else {
	    return $value;
	}
  }

  function NOF_IsEmpty( $value ) {
    if ( empty($value) ) {
        return TRUE;
    } else {
        return FALSE;
    }
  }

  class NOF_HTTP_Request
  {
      var $NOF_GET_VARS;
      var $NOF_POST_VARS;
      var $NOF_COOKIE_VARS;
      var $NOF_SESSION_VARS;
      var $NOF_SERVER_VARS;
      var $NOF_ENV_VARS;

      function createRequest() {
          global $HTTP_GET_VARS, $HTTP_POST_VARS, $HTTP_COOKIE_VARS, $HTTP_SESSION_VARS, $HTTP_SERVER_VARS, $HTTP_ENV_VARS;
          $parser_version = phpversion();

          if ($parser_version <= "4.1.0") {
              $this->NOF_GET_VARS     = $HTTP_GET_VARS;
              $this->NOF_POST_VARS    = $HTTP_POST_VARS;
              $this->NOF_COOKIE_VARS  = $HTTP_COOKIE_VARS;
              $this->NOF_SESSION_VARS = $HTTP_SESSION_VARS;
              $this->NOF_SERVER_VARS  = $HTTP_SERVER_VARS;
              $this->NOF_ENV_VARS     = $HTTP_ENV_VARS;
          } else {
          	  /* optional. uncomment if we want to actual start a session.
			  if (!isset($_SESSION)) {
				$errLevel = error_reporting();
				error_reporting(0); //none
				session_start();
				error_reporting($errLevel); //restore error level
			  }
			  */

              $this->NOF_GET_VARS     = $_GET;
              $this->NOF_POST_VARS    = $_POST;
              $this->NOF_COOKIE_VARS  = $_COOKIE;
			  $this->NOF_SESSION_VARS = (isset($_SESSION)) ? $_SESSION : array();
              $this->NOF_SERVER_VARS  = $_SERVER;
              $this->NOF_ENV_VARS     = $_ENV;
          }
      }

      function Form($name) {
          if (isset($this->NOF_POST_VARS[$name])) {
              return $this->NOF_POST_VARS[$name];
          } else {
              return $this->QueryString($name);
          }
      }

      function Cookies($name) {
          if (isset($this->NOF_COOKIE_VARS[$name]) ) {
              return $this->NOF_COOKIE_VARS[$name];
          } else {
              return "";
          }
      }

      function QueryString($name) {
          if (isset($this->NOF_GET_VARS[$name]) ) {
              return $this->NOF_GET_VARS[$name];
          } else {
              return "";
          }
      }

      function Session($name) {
          if (isset($this->NOF_SESSION_VARS[$name]) ) {
              return $this->NOF_SESSION_VARS[$name];
          } else {
              return "";
          }
      }

      function CGI($name) {
          if (isset($this->NOF_ENV_VARS[$name]) ) {
              return $this->NOF_ENV_VARS[$name];
          } else {
              return "";
          }
      }

      function Server($name) {
          if (isset($this->NOF_SERVER_VARS[$name]) ) {
              return $this->NOF_SERVER_VARS[$name];
          } else {
              return "";
          }
      }
  }

  $NOF_REQUEST = new NOF_HTTP_Request;
  $NOF_REQUEST->createRequest();
?>